***************** Instructions for the creation of the text file with the data that can be uploaded on WINBUGS
use dataset_full.dta, clear

replace gender=0 if gender==1
replace gender=1 if gender==2

drop if risk==. | left_right==. | proximity==. | education==. | gender==. | age==. | income==. | country==.
drop if risk==.a | left_right==.a | education==.a | gender==.a | age==.a | income==.a | country==.a
drop if risk==.b | left_right==.b | education==.b | gender==.b | age==.b | income==.b | country==.b
drop if risk==.c | left_right==.c | education==.c | gender==.c | age==.c | income==.c | country==.c

drop if year==2006 | year==2008

replace year=1 if year==1978
replace year=2 if year==1982
replace year=3 if year==1984
replace year=4 if year==1986
replace year=5 if year==1987
replace year=6 if year==1989
replace year=7 if year==1991
replace year=8 if year==1993
replace year=9 if year==1996

* set Norway as no. 13
replace country=13 if country==14
* set Finland as no. 14
replace country=14 if country==16
* set Sweden as no. 15
replace country=15 if country==17
* set Austria as no. 16
replace country=16 if country==18

* creation of data.txt
gen cons=1
wbarray risk left_right education gender age income proximity country year cons, format(%12.0f %12.0f %12.0f %12.0f %12.0f %12.0f %12.3f %12.0f %12.0f %12.0f) ///
  saving(data.txt, replace)

exit

***************** Instructions for the creation of the text files with the initial values that can be uploaded on WINBUGS
clear all
set obs 65955
gen delta=1 in 1/65955

* initials for variances (same across chains)
gen tau_b1=1 in 1/16
gen tau_b2=1 in 1/16
gen tau_b3=1 in 1/16
gen tau_b4=1 in 1/16
gen tau_b5=1 in 1/16
gen tau_b6=1 in 1/16
gen tau_b7=1 in 1/16
gen tau_u1=1 in 1/16
gen tau_u2=1 in 1/9

** First chain: inits_chain1.txt
* initials for betas
set seed 1
gen b1=-1+(2*runiform()) in 1/16
gen b2=-1+(2*runiform()) in 1/16
gen b3=-1+(2*runiform()) in 1/16
gen b4=-1+(2*runiform()) in 1/16
gen b5=-1+(2*runiform()) in 1/16
gen b6=-1+(2*runiform()) in 1/16
gen b7=-1+(2*runiform()) in 1/16
* initials for country intercepts
gen u1=-1+(2*runiform()) in 1/16
* initials for year intercepts
gen u2=-1+(2*runiform()) in 1/9

wbdata, c(wbvector tau_b1 if tau_b1!=. + wbvector tau_b2 if tau_b2!=. + wbvector tau_b3 if tau_b3!=. + wbvector tau_b4 if tau_b4!=. ///
+ wbvector tau_b5 if tau_b5!=. + wbvector tau_b6 if tau_b6!=. + wbvector tau_b7 if tau_b7!=. ///
+ wbvector tau_u1 if tau_u1!=. + wbvector tau_u2 if tau_u2!=. ///
+ wbvector b1 if b1!=. + wbvector b2 if b2!=. + wbvector b3 if b3!=. + wbvector b4 if b4!=. + wbvector b5 if b5!=. + wbvector b6 if b6!=. + wbvector b7 if b7!=. ///
+ wbvector u1 if u1!=. + wbvector u2 if u2!=. + wbvector delta) saving(inits_chain1.txt, replace)

drop b* u*

** Second chain: inits_chain2.txt
* initials for betas
set seed 2
gen b1=-1+(2*runiform()) in 1/16
gen b2=-1+(2*runiform()) in 1/16
gen b3=-1+(2*runiform()) in 1/16
gen b4=-1+(2*runiform()) in 1/16
gen b5=-1+(2*runiform()) in 1/16
gen b6=-1+(2*runiform()) in 1/16
gen b7=-1+(2*runiform()) in 1/16
* initials for country intercepts
gen u1=-1+(2*runiform()) in 1/16
* initials for year intercepts
gen u2=-1+(2*runiform()) in 1/9

wbdata, c(wbvector tau_b1 if tau_b1!=. + wbvector tau_b2 if tau_b2!=. + wbvector tau_b3 if tau_b3!=. + wbvector tau_b4 if tau_b4!=. ///
+ wbvector tau_b5 if tau_b5!=. + wbvector tau_b6 if tau_b6!=. + wbvector tau_b7 if tau_b7!=. ///
+ wbvector tau_u1 if tau_u1!=. + wbvector tau_u2 if tau_u2!=. ///
+ wbvector b1 if b1!=. + wbvector b2 if b2!=. + wbvector b3 if b3!=. + wbvector b4 if b4!=. + wbvector b5 if b5!=. + wbvector b6 if b6!=. + wbvector b7 if b7!=. ///
+ wbvector u1 if u1!=. + wbvector u2 if u2!=. + wbvector delta) saving(inits_chain2.txt, replace)

drop b* u*

** Third chain: inits_chain3.txt
* initials for betas
set seed 3
gen b1=-1+(2*runiform()) in 1/16
gen b2=-1+(2*runiform()) in 1/16
gen b3=-1+(2*runiform()) in 1/16
gen b4=-1+(2*runiform()) in 1/16
gen b5=-1+(2*runiform()) in 1/16
gen b6=-1+(2*runiform()) in 1/16
gen b7=-1+(2*runiform()) in 1/16
* initials for country intercepts
gen u1=-1+(2*runiform()) in 1/16
* initials for year intercepts
gen u2=-1+(2*runiform()) in 1/9

wbdata, c(wbvector tau_b1 if tau_b1!=. + wbvector tau_b2 if tau_b2!=. + wbvector tau_b3 if tau_b3!=. + wbvector tau_b4 if tau_b4!=. ///
+ wbvector tau_b5 if tau_b5!=. + wbvector tau_b6 if tau_b6!=. + wbvector tau_b7 if tau_b7!=. ///
+ wbvector tau_u1 if tau_u1!=. + wbvector tau_u2 if tau_u2!=. ///
+ wbvector b1 if b1!=. + wbvector b2 if b2!=. + wbvector b3 if b3!=. + wbvector b4 if b4!=. + wbvector b5 if b5!=. + wbvector b6 if b6!=. + wbvector b7 if b7!=. ///
+ wbvector u1 if u1!=. + wbvector u2 if u2!=. + wbvector delta) saving(inits_chain3.txt, replace)
